<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Vendas extends MY_Controller
{

    /**
     * author: Ramon Silva
     * email: silva018-mg@yahoo.com.br
     *
     */

    public function __construct()
    {
        parent::__construct();

        $this->load->helper('form');
        $this->load->model('vendas_model');
        $this->data['menuVendas'] = 'Vendas';
    }

    public function index()
    {
        $this->gerenciar();
    }

    public function gerenciar()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }

        $this->load->library('pagination');

        $this->data['configuration']['base_url'] = site_url('vendas/gerenciar/');
        $this->data['configuration']['total_rows'] = $this->vendas_model->count('vendas');

        $this->pagination->initialize($this->data['configuration']);

        $this->data['results'] = $this->vendas_model->get('vendas', '*', '', $this->data['configuration']['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'vendas/vendas';
        return $this->layout();
    }

    public function adicionar()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar Vendas.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('vendas') == false) {
            $this->data['custom_error'] = (validation_errors() ? true : false);
        } else {
            $dataVenda = $this->input->post('dataVenda');

            try {
                $dataVenda = explode('/', $dataVenda);
                $dataVenda = $dataVenda[2] . '-' . $dataVenda[1] . '-' . $dataVenda[0];
            } catch (Exception $e) {
                $dataVenda = date('Y/m/d');
            }
			$pcontas = 'Receitas de Vendas';
			$categoria = 'Vendas de Produtos';
            $data = [
                'dataVenda' => $dataVenda,
                'observacoes' => $this->input->post('observacoes'),
                'observacoes_cliente' => $this->input->post('observacoes_cliente'),
                'clientes_id' => $this->input->post('clientes_id'),
                'usuarios_id' => $this->input->post('usuarios_id'),
                'faturado' => 0,
            ];

            if (is_numeric($id = $this->vendas_model->add('vendas', $data, true))) {
                $this->session->set_flashdata('success', 'Venda iniciada com sucesso, adicione os produtos.');
                log_info('Adicionou uma venda.');
                redirect(site_url('vendas/editar/') . $id);
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
        }

        $this->data['view'] = 'vendas/adicionarVenda';
        return $this->layout();
    }

    public function editar()
    {
        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar vendas');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('vendas') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
            $dataVenda = $this->input->post('dataVenda');

            try {
                $dataVenda = explode('/', $dataVenda);
                $dataVenda = $dataVenda[2] . '-' . $dataVenda[1] . '-' . $dataVenda[0];
            } catch (Exception $e) {
                $dataVenda = date('Y/m/d');
            }

            $data = [
                'dataVenda' => $dataVenda,
                'observacoes' => $this->input->post('observacoes'),
                'observacoes_cliente' => $this->input->post('observacoes_cliente'),
                'usuarios_id' => $this->input->post('usuarios_id'),
                'clientes_id' => $this->input->post('clientes_id'),
            ];

            if ($this->vendas_model->edit('vendas', $data, 'idVendas', $this->input->post('idVendas')) == true) {
                $this->session->set_flashdata('success', 'Venda editada com sucesso!');
                log_info('Alterou uma venda. ID: ' . $this->input->post('idVendas'));
                redirect(site_url('vendas/editar/') . $this->input->post('idVendas'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro</p></div>';
            }
        }

        $this->data['result'] = $this->vendas_model->getById($this->uri->segment(3));
        $this->data['produtos'] = $this->vendas_model->getProdutos($this->uri->segment(3));
        $this->data['view'] = 'vendas/editarVenda';
        return $this->layout();
    }

    public function visualizar()
    {
        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }

        $this->data['custom_error'] = '';
        $this->load->model('mapos_model');
        $this->data['result'] = $this->vendas_model->getById($this->uri->segment(3));
        $this->data['produtos'] = $this->vendas_model->getProdutos($this->uri->segment(3));
        $this->data['emitente'] = $this->mapos_model->getEmitente();
        $this->data['modalGerarPagamento'] = $this->load->view(
            'cobrancas/modalGerarPagamento',
            [
                'id' => $this->uri->segment(3),
                'tipo' => 'venda',
            ],
            true
        );

        $this->data['view'] = 'vendas/visualizarVenda';
		
		/* if ($return = $this->vendas_model->valorTotalOS($this->uri->segment(3))) {
            $this->data['totalServico'] = $return['totalServico'];
            $this->data['totalProdutos'] = $return['totalProdutos'];
			$this->data['totalDescontos'] = $return['totalDescontos'];
        } */

        return $this->layout();
    }
	
	
	public function enviar_email()
    {
        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para enviar Vendas por e-mail.');
            redirect(base_url());
        }

        $this->load->model('mapos_model');
        $this->load->model('usuarios_model');
        $this->data['result'] = $this->vendas_model->getById($this->uri->segment(3));
        if (!isset($this->data['result']->email)) {
            $this->session->set_flashdata('error', 'O cliente não tem e-mail cadastrado.');
            redirect(site_url('vendas'));
        }

        $this->data['produtos'] = $this->vendas_model->getProdutos($this->uri->segment(3));
        //$this->data['servicos'] = $this->vendas_model->getServicos($this->uri->segment(3));
        $this->data['emitente'] = $this->mapos_model->getEmitente();

        if (!isset($this->data['emitente'][0]->email)) {
            $this->session->set_flashdata('error', 'Efetue o cadastro dos dados de emitente');
            redirect(site_url('vendas'));
        }
		$id = $this->uri->segment(3);
        $idVendas = $this->uri->segment(3);
		$remetentes = [
        $this->data['result']->email,
        ];
        $emitente = $this->data['emitente'][0];
        $tecnico = $this->usuarios_model->getById($this->data['result']->usuarios_id);

        // Verificar configuração de notificação
        if ($this->data['configuration']['vendas_notification'] != 'nenhum') {
            $remetentes = [];
            switch ($this->data['configuration']['vendas_notification']) {
                case 'todos':
                    array_push($remetentes, $this->data['result']->email);
                    array_push($remetentes, $tecnico->email);
                    array_push($remetentes, $emitente->email);
                    break;
                case 'cliente':
                    array_push($remetentes, $this->data['result']->email);
                    break;
                case 'tecnico':
                    array_push($remetentes, $tecnico->email);
                    break;
                case 'emitente':
                    array_push($remetentes, $emitente->email);
                    break;
                default:
                    array_push($remetentes, $this->data['result']->email);
                    break;
            }
            $enviouEmail = $this->enviarOsPorEmail($idVendas, $remetentes, 'venda');

            if ($enviouEmail) {
				
				// Show success notification or other things here
                $this->load->model('historico_model', '', true);
                $today = date("Y-m-d");
                $data = array(
                    'idVendas' => $id,
         			'data' => date('Y-m-d H:i:s'),
                    'responsavel' => 'MedicoOdonto',
                    'status' => 'Alerta',
                    'canal' => 'Email',
                    'comentarios' => 'Email automático alertando sobre alteração de status do atendimento.',
                );

                if ($this->historico_model->add('historico', $data) == true) {
                
                $this->load->model('mapos_model');
                $this->load->model('usuarios_model');

                $idVendas = $this->input->post('idVendas');

                $vendas = $this->vendas_model->getById($idVendas);
                $emitente = $this->mapos_model->getEmitente()[0];
                $tecnico = $this->usuarios_model->getById($vendas->usuarios_id);
        
				$emitente = $this->data['emitente'][0];
				$tecnico = $this->usuarios_model->getById($this->data['result']->usuarios_id);
		  
                $this->session->set_flashdata('success', 'O email está sendo processado e será enviado em breve para o cliente.');
                log_info('Enviou e-mail para o cliente: ' . $this->data['result']->nomeCliente . '. E-mail: ' . $this->data['result']->email);
                redirect(site_url('vendas'));
            } else {
                //$this->session->set_flashdata('error', 'Ocorreu um erro ao enviar e-mail para o cliente.');
				$this->session->set_flashdata('success', 'O email está sendo processado e será enviado em breve para o cliente.');
			   redirect(site_url('vendas'));
				}
			}

				
		}
				$this->session->set_flashdata('error', 'O sistema está com uma configuração ativada para não notificar. Entre em contato com o administrador.');
				redirect(site_url('vendas'));
	}
	
	private function enviarOsPorEmail($idVendas, $remetentes, $assunto)
    {
        $dados = [];

        $this->load->model('mapos_model');
        $dados['result'] = $this->vendas_model->getById($idVendas);
        if (!isset($dados['result']->email)) {
            return false;
        }

        $dados['produtos'] = $this->vendas_model->getProdutos($idVendas);
        //$dados['servicos'] = $this->os_model->getServicos($idOs);
        $dados['emitente'] = $this->mapos_model->getEmitente();

        $emitente = $dados['emitente'][0]->email;
        if (!isset($emitente)) {
            return false;
        }

        $html = $this->load->view('vendas/emails/vendas', $dados, true);

        $this->load->model('email_model');

        $remetentes = array_unique($remetentes);
        foreach ($remetentes as $remetente) {
            $headers = ['From' => $emitente, 'Subject' => $assunto, 'Return-Path' => ''];
            $email = [
                'to' => $remetente,
                'message' => $html,
                'status' => 'pending',
                'date' => date('Y-m-d H:i:s'),
                'headers' => serialize($headers),
            ];
            $this->email_model->add('email_queue', $email);
        }

        return true;
    }


    public function imprimir()
    {
        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }

        $this->data['custom_error'] = '';
        $this->load->model('mapos_model');
        $this->data['result'] = $this->vendas_model->getById($this->uri->segment(3));
        $this->data['produtos'] = $this->vendas_model->getProdutos($this->uri->segment(3));
        $this->data['emitente'] = $this->mapos_model->getEmitente();
		 $this->data['qrCode'] = $this->vendas_model->getQrCode(
            $this->uri->segment(3),
            $this->data['configuration']['pix_key'],
            $this->data['emitente'][0]
        );

        $this->load->view('vendas/imprimirVenda', $this->data);
    }

    public function imprimirTermica()
    {
        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }

        $this->data['custom_error'] = '';
        $this->load->model('mapos_model');
        $this->data['result'] = $this->vendas_model->getById($this->uri->segment(3));
        $this->data['produtos'] = $this->vendas_model->getProdutos($this->uri->segment(3));
        $this->data['emitente'] = $this->mapos_model->getEmitente();
		 $this->data['qrCode'] = $this->vendas_model->getQrCode(
            $this->uri->segment(3),
            $this->data['configuration']['pix_key'],
            $this->data['emitente'][0]
        );
        $this->load->view('vendas/imprimirVendaTermica', $this->data);
    }

    public function excluir()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir vendas');
            redirect(base_url());
        }

        $this->load->model('vendas_model');

        $id = $this->input->post('id');
        $venda = $this->vendas_model->getByIdCobrancas($id);
        if ($venda == null) {
            $venda = $this->vendas_model->getById($id);
            if ($venda == null) {
                $this->session->set_flashdata('error', 'Erro ao tentar excluir venda.');
                redirect(site_url('vendas/gerenciar/'));
            }
        }


        if ($venda->idCobranca != null) {
            if ($venda->status == "canceled") {
                $this->vendas_model->delete('cobrancas', 'vendas_id', $id);
            } else {
                $this->session->set_flashdata('error', 'Existe uma cobrança associada a esta venda, deve cancelar e/ou excluir a cobrança primeiro!');
                redirect(site_url('vendas/gerenciar/'));
            }
        }

        $this->vendas_model->delete('itens_de_vendas', 'vendas_id', $id);
        $this->vendas_model->delete('vendas', 'idVendas', $id);
        if ((int) $venda->faturado === 1) {
            $this->vendas_model->delete('lancamentos', 'descricao', "Fatura de Venda - #${id}");
        }

        log_info('Removeu uma venda. ID: ' . $id);

        $this->session->set_flashdata('success', 'Venda excluída com sucesso!');
        redirect(site_url('vendas/gerenciar/'));
    }

    public function autoCompleteProduto()
    {
        if (isset($_GET['term'])) {
            $q = strtolower($_GET['term']);
            $this->vendas_model->autoCompleteProduto($q);
        }
    }

    public function autoCompleteCliente()
    {
        if (isset($_GET['term'])) {
            $q = strtolower($_GET['term']);
            $this->vendas_model->autoCompleteCliente($q);
        }
    }

    public function autoCompleteUsuario()
    {
        if (isset($_GET['term'])) {
            $q = strtolower($_GET['term']);
            $this->vendas_model->autoCompleteUsuario($q);
        }
    }

    public function adicionarProduto()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar vendas.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->form_validation->set_rules('quantidade', 'Quantidade', 'trim|required');
        $this->form_validation->set_rules('idProduto', 'Produto', 'trim|required');
        $this->form_validation->set_rules('idVendasProduto', 'Vendas', 'trim|required');

        if ($this->form_validation->run() == false) {
            echo json_encode(['result' => false]);
        } else {
            $preco = $this->input->post('preco');
            $quantidade = $this->input->post('quantidade');
            $subtotal = $preco * $quantidade;
            $produto = $this->input->post('idProduto');
            $data = [
                'quantidade' => $quantidade,
                'subTotal' => $subtotal,
                'produtos_id' => $produto,
                'preco' => $preco,
                'vendas_id' => $this->input->post('idVendasProduto'),
            ];

            if ($this->vendas_model->add('itens_de_vendas', $data) == true) {
                $this->load->model('produtos_model');

                if ($this->data['configuration']['control_estoque']) {
                    $this->produtos_model->updateEstoque($produto, $quantidade, '-');
                }

                log_info('Adicionou produto a uma venda.');

                echo json_encode(['result' => true]);
            } else {
                echo json_encode(['result' => false]);
            }
        }
    }

    public function excluirProduto()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar Vendas');
            redirect(base_url());
        }

        $ID = $this->input->post('idProduto');
        if ($this->vendas_model->delete('itens_de_vendas', 'idItens', $ID) == true) {
            $quantidade = $this->input->post('quantidade');
            $produto = $this->input->post('produto');

            $this->load->model('produtos_model');

            if ($this->data['configuration']['control_estoque']) {
                $this->produtos_model->updateEstoque($produto, $quantidade, '+');
            }

            log_info('Removeu produto de uma venda.');
            echo json_encode(['result' => true]);
        } else {
            echo json_encode(['result' => false]);
        }
    }

    public function faturar()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar Vendas');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('receita') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
            $venda_id = $this->input->post('vendas_id');
            $vencimento = $this->input->post('vencimento');
            $recebimento = $this->input->post('recebimento');
			$pcontas = $this->input->post('pcontas');
            $categoria = $this->input->post('categoria');

            try {
                $vencimento = explode('/', $vencimento);
                $vencimento = $vencimento[2] . '-' . $vencimento[1] . '-' . $vencimento[0];

                if ($recebimento != null) {
                    $recebimento = explode('/', $recebimento);
                    $recebimento = $recebimento[2] . '-' . $recebimento[1] . '-' . $recebimento[0];
                }
            } catch (Exception $e) {
                $vencimento = date('Y/m/d');
            }
			
			$pcontas = '7 Receita de Venda';
			$categoria = 'Venda de Material';

            $data = [
                'vendas_id' => $venda_id,
                'descricao' => set_value('descricao'),
                'valor' => $this->input->post('valor'),
				'valor_desconto' => $this->input->post('valor_desconto'),
                'clientes_id' => $this->input->post('clientes_id'),
                'data_vencimento' => $vencimento,
                'data_pagamento' => $recebimento,
                'baixado' => $this->input->post('recebido') == 1 ? true : false,
                'cliente_fornecedor' => set_value('cliente'),
				'pcontas' => $pcontas,
				'categoria' => $categoria,
                'forma_pgto' => $this->input->post('formaPgto'),
                'tipo' => $this->input->post('tipo'),
                'usuarios_id' => $this->session->userdata('id'),
            ];

            if ($this->vendas_model->add('lancamentos', $data) == true) {
                $venda = $this->input->post('vendas_id');

                $this->db->set('faturado', 1);
                $this->db->set('valorTotal', $this->input->post('valor'));
				$this->db->set('valor_desconto',$this->input->post('valor_desconto'));
                $this->db->where('idVendas', $venda);
                $this->db->update('vendas');

                log_info('Faturou uma venda.');

                $this->session->set_flashdata('success', 'Venda faturada com sucesso!');
                $json = ['result' => true];
                echo json_encode($json);
                die();
            } else {
                $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar faturar venda.');
                $json = ['result' => false];
                echo json_encode($json);
                die();
            }
        }

        $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar faturar venda.');
        $json = ['result' => false];
        echo json_encode($json);
    }
	
	
	 function adicionarVenda_parc() {

      
		//$this->load->library('form_validation');
        //$this->data['custom_error'] = '';
        $urlAtual = $this->input->post('urlAtual');
        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'aLancamento')){
           $this->session->set_flashdata('error','Você não tem permissão para adicionar lançamentos.');
           redirect(base_url());
        
        } else {

			$qtdparcelas_parc = $this->input->post('qtdparcelas_parc');
			$entrada = $this->input->post('entrada');
			$valor_parc = $this->input->post('valor_parc');
			$valorparcelas = ($valor_parc - $entrada) / $qtdparcelas_parc;
			$venda_id = $this->input->post('vendas_id');
			
			if($entrada >= $valor_parc){
				$this->session->set_flashdata('error','O valor da entrada não pode ser maior ou igual ao valor total da receita!');
				redirect($urlAtual);
			}
			
			$dia_pgto = $this->input->post('dia_pgto');
			$dia_base_pgto = $this->input->post('dia_base_pgto');

            try {
                $dia_pgto = explode('/', $dia_pgto);
                $dia_pgto = $dia_pgto[2].'-'.$dia_pgto[1].'-'.$dia_pgto[0];
                
                $dia_base_pgto = explode('/', $dia_base_pgto);
                $dia_base_pgto = $dia_base_pgto[2].'-'.$dia_base_pgto[1].'-'.$dia_base_pgto[0];

            } catch (Exception $e) {
               $dia_pgto = date('Y/m/d');
               $dia_base_pgto = date('Y/m/d');
            }
			
		if($entrada == 0){
			$loops = 1;
			while ($loops <= $qtdparcelas_parc){

            $myDateTimeISO = $dia_base_pgto;
            $loopsmes = $loops - 1;
			$addThese = $loopsmes;
			$myDateTime = new DateTime($myDateTimeISO);
			$myDayOfMonth = date_format($myDateTime,'j');
			date_modify($myDateTime,"+$addThese months");

			//Find out if the day-of-month has dropped
			$myNewDayOfMonth = date_format($myDateTime,'j');
			if ($myDayOfMonth > 28 && $myNewDayOfMonth < 4){
			//If so, fix by going back the number of days that have spilled over
			    date_modify($myDateTime,"-$myNewDayOfMonth days");
			}
			
			$pcontas = '7 Receita de Venda';
			$categoria = 'Venda de Material';
			$data = array(
				'vendas_id' => $venda_id,
				'clientes_id' => $this->input->post('clientes_id'),
                'descricao' => $this->input->post('descricao_parc').' - Parcela ['.$loops.'/'.$qtdparcelas_parc.']',
				'valor' => $valorparcelas,
				'valor_desconto' => $this->input->post('desconto_parc'),
				'data_vencimento' => date_format($myDateTime,"Y-m-d"),
				//'data_pagamento' => $recebimento != null ? $recebimento : date('Y-m-d'),
				'data_pagamento' => $recebimento != null ? $recebimento : date_format($myDateTime,"Y-m-d"),
				'baixado' => 0,
				'cliente_fornecedor' => $this->input->post('cliente_parc'),
				'forma_pgto' => $this->input->post('formaPgto_parc'),
				'tipo' => $this->input->post('tipo_parc'),
				'pcontas' => $pcontas,
				'categoria' => $categoria,
				'usuarios_id' => $this->session->userdata('id'),
            );

            if ($this->vendas_model->add('lancamentos',$data) == TRUE) {
                $venda = $this->input->post('vendas_id');
				$this->db->set('faturado', 1);
                $this->db->set('valorTotal', $this->input->post('valor'));
				$this->db->set('valor_desconto',$this->input->post('desconto_parc'));
                $this->db->where('idVendas', $venda);
                $this->db->update('vendas');
				 log_info('Faturou uma venda.');
				$this->session->set_flashdata('success','Venda faturada com sucesso!');

            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
			$loops++;
			}

			redirect($urlAtual);

		}else{
			$pcontas = '7 Receita de Venda';
			$categoria = 'Venda de Material';
			$data1 = array(
				'vendas_id' => $venda_id,
                'descricao' => $this->input->post('descricao_parc'),
				'valor' => $entrada,
				'clientes_id' => $this->input->post('clientes_id'),
				'data_vencimento' => $dia_pgto,
				//'data_pagamento' => $this->input->post('pagamento'),
				//'data_pagamento' => $dia_pgto != null ? $dia_pgto : date('Y-m-d'),
				'data_pagamento' => $dia_pgto != null ? $dia_pgto : date_format($myDateTime,"Y-m-d"),
				'baixado' => 1,
				'cliente_fornecedor' => $this->input->post('cliente_parc'),
				'forma_pgto' => $this->input->post('formaPgto_parc'),
				'tipo' => $this->input->post('tipo_parc'),
				'pcontas' => $pcontas,
				'categoria' => $categoria,
				'usuarios_id' => $this->session->userdata('id'),
            );
			$this->vendas_model->add1('lancamentos',$data1);
			
			$loops = 1;
			while ($loops <= $qtdparcelas_parc){
            $myDateTimeISO = $dia_base_pgto;
            $loopsmes = $loops - 1;
			$addThese = $loopsmes;
			$myDateTime = new DateTime($myDateTimeISO);
			$myDayOfMonth = date_format($myDateTime,'j');
			date_modify($myDateTime,"+$addThese months");

			//Find out if the day-of-month has dropped
			$myNewDayOfMonth = date_format($myDateTime,'j');
			if ($myDayOfMonth > 28 && $myNewDayOfMonth < 4){
			//If so, fix by going back the number of days that have spilled over
			    date_modify($myDateTime,"-$myNewDayOfMonth days");
			}
			$pcontas = '7 Receita de Venda';
			$categoria = 'Venda de Material';
			$data = array(
				'vendas_id' => $venda_id,
                'descricao' => $this->input->post('descricao_parc').' - Parcela ['.$loops.'/'.$qtdparcelas_parc.']',
				//'comissao' => $this->input->post('comissao'),
				'valor' => $this->input->post('valorparcelas'),
				'valor_desconto' => $this->input->post('desconto_parc'),
				'data_vencimento' => date_format($myDateTime,"Y-m-d"),
				//'data_pagamento' => $this->input->post('pagamento'),
				'data_pagamento' => date_format($myDateTime,"Y-m-d"),
				'baixado' => 0,
				'cliente_fornecedor' => $this->input->post('cliente_parc'),
				'clientes_id' => $this->input->post('clientes_id'),
				'forma_pgto' => $this->input->post('formaPgto_parc'),
				'tipo' => $this->input->post('tipo_parc'),
				'pcontas' => $pcontas,
				'categoria' => $categoria,
				'usuarios_id' => $this->session->userdata('id'),
            );

            if ($this->vendas_model->add('lancamentos',$data) == TRUE) {
                $venda = $this->input->post('vendas_id');
				$this->db->set('faturado', 1);
                $this->db->set('valorTotal', $this->input->post('valor'));
				$this->db->set('valor_desconto',$this->input->post('desconto_parc'));
                $this->db->where('idVendas', $venda);
                $this->db->update('vendas');
				 log_info('Faturou uma venda.');
				$this->session->set_flashdata('success','Venda faturada com sucesso!');
            }
             else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
			$loops++;
			}

			redirect($urlAtual);
			
		}
}

        $this->session->set_flashdata('error','Ocorreu um erro ao tentar adicionar receita');
        redirect($urlAtual);
           
    } 
	
	
	
	
}
