<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title>iTecPro - Login</title>
    <meta charset="UTF-8" />
     <meta name="theme-color" content="#0088ff" /><meta name="viewport" content="width=device-width, initial-scale=1.0" /><link rel="icon" href="https://itecpro.com.br/os4/assets/img/ico.png" sizes="32x32" />
<link rel="icon" href="https://itecpro.com.br/os4/assets/img/ico.png" sizes="192x192" />
<link rel="apple-touch-icon-precomposed" href="https://itecpro.com.br/os4/assets/img/ico.png" />
<meta name="msapplication-TileImage" content="https://itecpro.com.br/os4/assets/img/ico.png" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/bootstrap.min.css" />
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/bootstrap-responsive.min.css" />
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/matrix-login.css" />
    <link href="<?= base_url(); ?>assets/font-awesome/css/font-awesome.css" rel="stylesheet" />
    <style type="text/css">
    body {
    background-image: url(http://os.itecpro.com.br/assets/img/fundohome.jpg);
   background-repeat: no-repeat;
    background-position: center;
    background-size: cover;
    width: 100%;
    height: 100%;
}
    </style>
<script src="<?= base_url() ?>assets/js/jquery-1.12.4.min.js"></script>
</head>

	
<body>
<div id="loginbox">
        <form class="form-vertical" id="formLogin" method="post" action="<?= site_url('login/verificarLogin') ?>">
            <?php if ($this->session->flashdata('error') != null) { ?>
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?= $this->session->flashdata('error'); ?>
                </div>
            <?php } ?>
            <div class="control-group normal_text">
              <h3><img src="<?= base_url() ?>assets/img/logo3.png" alt="Logo" /></h3>
              <p>&nbsp;</p>
              <p>&nbsp;</p>
            </div>
            <div class="control-group">
                <div class="controls">
                    <div class="main_input_box">
                        <span class="add-on bg_lg"><i class="fas fa-user"></i></span><input id="email" name="email" type="text" placeholder="Email" />
                    </div>
                </div>
            </div>
            <div class="control-group">
                <div class="controls">
                    <div class="main_input_box">
                        <span class="add-on bg_lb"><i class="fas fa-lock"></i></span><input name="senha" type="password" placeholder="Senha" />
                    </div>
                </div>
            </div>
            <div class="form-actions" style="text-align: center">
                <div id="progress-acessar" class='hide progress progress-info progress-striped active'>
                    <div class='bar' style='width: 100%'></div>
                </div>
                <button id="btn-acessar" class="btn btn-success btn-large" /> Acessar</button>
            </div>
        </form>
        <center>
          <p>&nbsp;</p>
          <p>&nbsp;</p>
          <p>Acesso restrito a técnicos da iTecPro - Apple Service | <a href="https://os.itecpro.com.br/index.php/mine/painel">Area do Cliente</a></p>
        </center>
</div>



    <a href="#notification" id="call-modal" role="button" class="btn" data-toggle="modal" style="display: none ">notification</a>
    <div id="notification" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h4 id="myModalLabel">iTecPro - Especializada Apple Service</h4>
        </div>
        <div class="modal-body">
            <h5 style="text-align: center" id="message">Ops! Sua memória pode ter sido contaminada por algum android... </h5>
        </div>
        <div class="modal-footer">
            <button class="btn btn-primary" data-dismiss="modal" aria-hidden="true">Fechar</button>
        </div>
    </div>
    
    
<script src="<?= base_url() ?>assets/js/bootstrap.min.js"></script>
<script src="<?= base_url() ?>assets/js/validate.js"></script>
<script type="text/javascript">
        $(document).ready(function() {

            $('#email').focus();
            $("#formLogin").validate({
                rules: {
                    email: {
                        required: true,
                        email: true
                    },
                    senha: {
                        required: true
                    }
                },
                messages: {
                    email: {
                        required: 'Campo Requerido.',
                        email: 'Insira Email válido'
                    },
                    senha: {
                        required: 'Campo Requerido.'
                    }
                },
                submitHandler: function(form) {
                    var dados = $(form).serialize();
                    $('#btn-acessar').addClass('disabled');
                    $('#progress-acessar').removeClass('hide');

                    $.ajax({
                        type: "POST",
                        url: "<?= site_url('login/verificarLogin?ajax=true'); ?>",
                        data: dados,
                        dataType: 'json',
                        success: function(data) {
                            if (data.result == true) {
                                window.location.href = "<?= site_url('mapos'); ?>";
                            } else {


                                $('#btn-acessar').removeClass('disabled');
                                $('#progress-acessar').addClass('hide');
                                
                                $('#message').text(data.message || 'Os dados de acesso estão incorretos, por favor tente novamente!');
                                $('#call-modal').trigger('click');
                            }
                        }
                    });

                    return false;
                },

                errorClass: "help-inline",
                errorElement: "span",
                highlight: function(element, errorClass, validClass) {
                    $(element).parents('.control-group').addClass('error');
                },
                unhighlight: function(element, errorClass, validClass) {
                    $(element).parents('.control-group').removeClass('error');
                    $(element).parents('.control-group').addClass('success');
                }
            });

        });
    </script>

</body>

</html>
