<?php

class Fornecedores extends MY_Controller {

    /**
     * author: Ramon Silva 
     * email: silva018-mg@yahoo.com.br
     * 
     */
    function __construct() {
        parent::__construct();
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }
        $this->load->helper(array('codegen_helper'));
        $this->load->model('fornecedores_model', '', TRUE);
        $this->data['menuFornecedores'] = 'fornecedores';
        $this->data['menuCadastros'] = 'cadastros';
    }

    function index() {
        $this->data['results'] = $this->fornecedores_model->getFornecedores();
        $this->data['view'] = 'fornecedores/fornecedores';
        //$this->load->view('tema/topo', $this->data);
        //$this->gerenciar();
		return $this->layout();
    }

    function gerenciar() {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vCliente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar clientes.');
            redirect(base_url());
        }
        $this->load->library('table');
        $this->load->library('pagination');
		$this->pagination->initialize($this->data['configuration']);


        $this->data['results'] = $this->clientes_model->get('clientes', 'idClientes,nomeCliente,documento,telefone,celular,email,rua,numero,bairro,cidade,estado,cep', '', $this->data['configuration']['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'clientes/clientes';
        //$this->load->view('tema/topo', $this->data);
		return $this->layout();
    }

    function adicionar() {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aCliente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar clientes.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('fornecedores') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
            $data = array(
                'nomeCliente' => set_value('nomeCliente'),
                'documento' => set_value('documento'),
                'inscricaoEstadual' => set_value('inscricaoE'),
                'inscricaoMunicipal' => set_value('inscricaoM'),
                'responsavel' => set_value('responsavel'),
                'telefone' => set_value('telefone'),
                'celular' => $this->input->post('celular'),
                'email' => set_value('email'),
                'rua' => set_value('rua'),
                'numero' => set_value('numero'),
				'complemento' => set_value('complemento'),
                'bairro' => set_value('bairro'),
                'cidade' => set_value('cidade'),
                'estado' => set_value('estado'),
                'cep' => set_value('cep'),
                'dataCadastro' => date('Y-m-d'),
                'usuarioCadastro' => $this->session->userdata('id'),
				'fornecedor' => (set_value('fornecedor') == true ? 1 : 0),
            );

            if ($this->fornecedores_model->add('fornecedores', $data) == TRUE) {
                $this->session->set_flashdata('success', 'Fornecedor adicionado com sucesso!');
                redirect(base_url() . 'index.php/fornecedores/adicionar/');
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
        }
        $this->data['view'] = 'fornecedores/adicionarFornecedor';
        return $this->layout();
    }

    function editar() {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }


        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eCliente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar clientes.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';
        $id = $this->uri->segment(3);

        if ($this->form_validation->run('fornecedores',$id) == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
            $data = array(
                'nomeCliente' => $this->input->post('nomeCliente'),
				'documento' => $this->input->post('documento'),
                'inscricaoEstadual' => $this->input->post('inscricaoE'),
                'inscricaoMunicipal' => $this->input->post('inscricaoM'),
                'responsavel' => $this->input->post('responsavel'),
                'telefone' => $this->input->post('telefone'),
                'celular' => $this->input->post('celular'),
                'email' => $this->input->post('email'),
                'rua' => $this->input->post('rua'),
                'numero' => $this->input->post('numero'),
				'complemento' => $this->input->post('complemento'),
                'bairro' => $this->input->post('bairro'),
                'cidade' => $this->input->post('cidade'),
                'estado' => $this->input->post('estado'),
                'cep' => $this->input->post('cep'),
                'fornecedor' => (set_value('fornecedor') == true ? 1 : 0),
            );

            if ($this->fornecedores_model->edit('fornecedores', $data, 'idFornecedor', $this->input->post('idFornecedor')) == TRUE) {
                $this->session->set_flashdata('success', 'Fornecedor editado com sucesso!');
				log_info('Alterou um fornecedor. ID' . $this->input->post('idFornecedor'));
                redirect(base_url() . 'index.php/fornecedores/editar/' . $this->input->post('idFornecedor'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro ao alterar o fornecedor.</p></div>';
            }
        }


        $this->data['result'] = $this->fornecedores_model->getById($this->uri->segment(3));
        $this->data['view'] = 'fornecedores/editarFornecedor';
        return $this->layout();
    }

    public function visualizar() {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vCliente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar clientes.');
            redirect(base_url());
        }

        $this->data['custom_error'] = '';
        $this->data['result'] = $this->clientes_model->getById($this->uri->segment(3));
        $this->data['results'] = $this->clientes_model->getOsByCliente($this->uri->segment(3));
        $this->data['view'] = 'clientes/visualizar';
        return $this->layout();
    }

    public function excluir() {


        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dCliente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir clientes.');
            redirect(base_url());
        }


        $id = $this->input->post('id');
        if ($id == null) {

            $this->session->set_flashdata('error', 'Erro ao tentar excluir cliente.');
            redirect(base_url() . 'index.php/fornecedores');
        }

        if ($this->fornecedores_model->getLancamentoByFornecedor($id) == TRUE) {
            $this->session->set_flashdata('error', 'Existem lancamentos vinculados a este fornecedor! não é possível excluir.');
            redirect(base_url() . 'index.php/fornecedores');
        } else {
            $this->fornecedores_model->delete('fornecedores', 'idFornecedor', $id);

            $this->session->set_flashdata('success', 'Fornecedor excluido com sucesso!');
            redirect(base_url() . 'index.php/fornecedores/');
        }
    }
    
    public function autoCompleteFornecedor() {
        
        $term = $this->input->get('term');
        
        if (isset($term)) {
            $q = strtolower($term);
            $this->fornecedores_model->autoCompleteFornecedor($q);
        }
    }

}
