<?php

class Contas_model extends CI_Model {

    /**
     * author: Ramon Silva 
     * email: silva018-mg@yahoo.com.br
     * 
     */
    function __construct() {
        parent::__construct();
    }

    function getContas() {
        $this->db->order_by('idContas', 'desc');
        $query = $this->db->get('contas');
        return $query->result();
    }

    function getById($id) {
        $this->db->where('idContas', $id);
        $this->db->limit(1);
        return $this->db->get('contas')->row();
    }

    function add($table, $data) {
        $this->db->insert($table, $data);
        if ($this->db->affected_rows() == '1') {
            return TRUE;
        }

        return FALSE;
    }

    function edit($table, $data, $fieldID, $ID) {
        $this->db->where($fieldID, $ID);
        $this->db->update($table, $data);

        if ($this->db->affected_rows() >= 0) {
            return TRUE;
        }

        return FALSE;
    }

    function delete($table, $fieldID, $ID) {
        $this->db->where($fieldID, $ID);
        $this->db->delete($table);
        if ($this->db->affected_rows() == '1') {
            return TRUE;
        }

        return FALSE;
    }

    function getContasOs($id) {
        $this->db->where('contas_id', $id);
        return $this->db->get('lancamentos')->row();
    }

    function getContasDropdown() {
        $this->db->select('idContas,conta');
        $this->db->order_by('conta');
        $results = $this->db->get('contas')->result();
        $list = array();
        foreach ($results as $result) {
            $list[$result->idContas] = $result->conta;
        }
        return $list;
    }

}
