<?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'aProduto')) { ?>
    <a href="<?php echo base_url(); ?>index.php/produtos/adicionar" class="btn btn-success"><i class="fas fa-plus"></i> Adicionar Produto</a>
    <!--<a href="<?php echo base_url(); ?>index.php/produtos/importar" class="btn btn-success"><i class=" fas fa-download icon-white"></i> Importar .xml <i class="icon-info-sign tip-top" title="Dica: Antes de importar, exporte o modelo da tabela e edite as linhas para inclusão e salve no formato .xml "></i></a>
    <a href="<?php echo base_url(); ?>index.php/produtos/gerarexcel" class="btn btn-primary"><i class=" fas fa-upload icon-white"></i> Exportar .xls</a>-->
	
<?php } ?>

<div class="widget-box">
    <div class="widget-title">
        <span class="icon">
            <i class="fas fa-shopping-bag"></i>
        </span>
        <h5>Produtos</h5>
    </div>
    <div class="widget-content nopadding tab-content">
        <table id="tabela" class="table table-bordered ">
            <thead>
            <tr style="background-color: #99b6ff">
                <th>Cod. Produto</th>
                <th>Produto</th>
				<th>Preço</th>
				<th>Estoque</th>
                
                <th>Ações</th>
            </tr>
            </thead>
            <tbody>
			
			<?php foreach ($results as $r) {
      $results = ($r->estoque);
      //$estoque = floor($results / (60 * 60 * 24));
      
	  
			
        switch ($results) {
			
			case ( $results < '1' ):
            $color = '#FF0000'; //vermelho
                    break;
					
        
        case ( $results < $r->estoqueMinimo ):
            $color = '#FF0000'; //vermelho
                    break;
          
          case ( $results == $r->estoqueMinimo ):
                    $color = '#FFC125';  //amarelo
                    break;
        
          case ( $results > $r->estoqueMinimo ):
            $color = '#3CB371'; //verde
                    break;
        
         
                default:
                    $color = '#FF0000';  //vermelho
                    break;
            }
			
			if ($results <= 1) {
              $color = '#FF0000'; //vermelho
                         }  else {
              
            }
             ?>

            <tr>
              <td style='text-align:center;vertical-align:middle'><?= $r->idProdutos; ?></td>
              
              <td><?= $r->descricao; ?></td>
              
              <td><?php echo 'R$ '. number_format($r->precoVenda, 2, ',', '.') ?></td>
              <?php echo '<td style= text-align:center;vertical-align:middle" <h5> <span class="badge" style="background-color: '.$color.'; border-color: '.$color.'">'.$r->estoque.'</span></h5></td>'?>
              
                     
							<td>
                                <?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) { ?>
                                    <a href="<?php echo base_url('index.php/produtos/visualizar/') . $r->idProdutos; ?> " style="margin-right: 1%" class="btn tip-top" title="Detalhes"><i class=" fas fa-eye"></i></a>
                                    
									<?php
                                }
                                if ($this->permission->checkPermission($this->session->userdata('permissao'), 'eProduto')) { ?>
                                    
                                    <a href="<?php echo base_url('index.php/produtos/editar/') . $r->idProdutos; ?>" style="margin-right: 1%" class="btn btn-info tip-top" title="Editar"><i class=" fas fa-edit"></i></a>
                                    
									<?php
								}
								if ($this->permission->checkPermission($this->session->userdata('permissao'), 'eProduto')) { 
									echo '<a href="#atualizar-estoque" role="button" data-toggle="modal" produto="' . $r->idProdutos . '" estoque="' . $r->estoque . '" descricao="' . $r->descricao . '" style="margin-right: 1%" class="btn btn-primary tip-top" title="Adicionar"><i class=" fas fa-plus "></i></a>';
									?>
									<?php
								}
									?>
								
									<?php
                                
                                if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dProduto')) { ?>
                                    
                                    <a href="#modal-excluir" role="button" data-toggle="modal" produto="<?= $r->idProdutos; ?>  "descr="<?= $r->descricao; ?>" style="margin-right: 1%" class="btn btn-danger tip-top" title="Excluir"><i class="fas fa-trash"></i></a>
									<?php
								} ?>
                            </td>
                        </tr> 
                   <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php echo $this->pagination->create_links(); ?>


<!-- Modal -->
<div id="modal-excluir" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <form action="<?php echo base_url() ?>index.php/produtos/excluir" method="post">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h5 id="myModalLabel"><i class="fas fa-trash-alt"></i> Excluir Produto</h5>
        </div>
        <div class="modal-body">
            <input type="hidden" id="idProduto" class="idProduto" name="id" value=""/>
            <h5 style="text-align: center">Deseja realmente excluir este produto?</h5>
        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancelar</button>
            <button class="btn btn-danger">Excluir</button>
        </div>
    </form>
</div>

<!-- Modal Estoque -->
<div id="atualizar-estoque" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <form action="<?php echo base_url() ?>index.php/produtos/atualizar_estoque" method="post" id="formEstoque">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h5 id="myModalLabel"><i class="fas fa-plus-square"></i> Atualizar Estoque</h5>
        </div>
        <div class="modal-body">
            <div class="control-group">
                <label for="estoqueAtual" class="control-label">Estoque Atual</label>
                <div class="controls">
                    <input id="estoqueAtual" type="text" name="estoqueAtual" value="" readonly />
                </div>
            </div>

            <div class="control-group">
                <label for="estoque" class="control-label">Adicionar Produtos<span class="required">*</span></label>
                <div class="controls">
                    <input type="hidden" id="idProduto" class="idProduto" name="id" value=""/>
                    <input id="estoque" type="text" name="estoque" value=""/>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancelar</button>
            <button class="btn btn-primary">Atualizar</button>
        </div>
    </form>
</div>

<!-- Modal Etiquetas -->
<div id="modal-etiquetas" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <form action="<?php echo base_url() ?>index.php/relatorios/produtosEtiquetas" method="get" target="_blank">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h5 id="myModalLabel">Gerar etiquetas com Código de Barras</h5>
        </div>
        <div class="modal-body">
            <div class="span12 alert alert-info" style="margin-left: 0"> Escolha o intervalo de produtos para gerar as etiquetas.</div>

            <div class="span12" style="margin-left: 0;">
                <div class="span6" style="margin-left: 0;">
                    <label for="valor">De</label>
                    <input class="span9" style="margin-left: 0" type="text" id="de_id" name="de_id" placeholder="ID do primeiro produto" value=""/>
                </div>


                <div class="span6">
                    <label for="valor">Até</label>
                    <input class="span9" type="text" id="ate_id" name="ate_id" placeholder="ID do último produto" value=""/>
                </div>

                <div class="span4">
                    <label for="valor">Qtd. do Estoque</label>
                    <input class="span12" type="checkbox" name="qtdEtiqueta" value="true"/>
                </div>

                <div class="span6">
                    <label class="span12" for="valor">Formato Etiqueta</label>
                    <select name="etiquetaCode">
                        <option value="EAN13">EAN-13</option>
                        <option value="UPCA">UPCA</option>
                        <option value="C93">CODE 93</option>
                        <option value="C128A">CODE 128</option>
                        <option value="CODABAR">CODABAR</option>
                        <option value="QR">QR-CODE</option>
                    </select>
                </div>

            </div>
        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancelar</button>
            <button class="btn btn-success">Gerar</button>
        </div>
    </form>
</div>

<script src="<?php echo base_url() ?>assets/js/jquery.validate.js"></script>
<!-- Modal Etiquetas e Estoque-->
<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('click', 'a', function (event) {
            var produto = $(this).attr('produto');
            var estoque = $(this).attr('estoque');
            $('.idProduto').val(produto);
            $('#estoqueAtual').val(estoque);
        });

        $('#formEstoque').validate({
            rules: {
                estoque: {
                    required: true,
                    number: true
                }
            },
            messages: {
                estoque: {
                    required: 'Campo Requerido.',
                    number: 'Informe um número válido.'
                }
            },
            errorClass: "help-inline",
            errorElement: "span",
            highlight: function (element, errorClass, validClass) {
                $(element).parents('.control-group').addClass('error');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).parents('.control-group').removeClass('error');
                $(element).parents('.control-group').addClass('success');
            }
        });
		
    });
</script>
